# 画面設計書 5-Invalid Objects

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のInvalid Objects画面（Page ID: 4）の設計書である。Invalid Objects画面は、テスト実行で検出されたルール違反オブジェクトの詳細を表示するモーダルダイアログ画面である。

### 本画面の処理概要

Invalid Objects画面は、ユニットテスト実行結果で「Failure」（失敗）となったルール検証において、どのオブジェクトがルールに違反しているかを一覧表示する。Dashboard画面のTest Executions Reportで、Failureステータスのレコードの「Details」リンクをクリックすることで本画面が開く。

**業務上の目的・背景**：ルール検証で違反が検出された場合、開発者は具体的にどのオブジェクト（テーブル、パッケージ、プロシージャなど）が違反しているかを知る必要がある。本画面は、違反オブジェクトの名前と詳細情報を一覧表示することで、開発者が修正すべき対象を明確に特定できるようにする。

**画面へのアクセス方法**：Dashboard画面のTest Executions Reportから、「Details」リンクをクリックしてモーダルダイアログとして開く。P4_QATR_ID（テスト結果ID）がURLパラメータとして渡される。

**主要な操作・処理内容**：
1. P4_QATR_IDに基づいてQA_TEST_RUN_INVALID_OBJECTSテーブルから違反オブジェクト一覧を取得
2. インタラクティブ・レポートで違反オブジェクトを表示
3. Closeボタンでダイアログを閉じて親画面に戻る

**画面遷移**：
- 遷移元：Dashboard画面（Test Executions Reportの「Details」リンク）
- 遷移先：なし（モーダルダイアログのためCloseで親画面に戻る）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 46 | 無効オブジェクト格納 | 主機能 | QA_TEST_RUN_INVALID_OBJECTSテーブルから違反オブジェクト一覧を表示 |

## 画面種別

モーダルダイアログ（一覧表示系・読み取り専用）

## URL/ルーティング

- Page ID: 4
- エイリアス: INVALID-OBJECTS
- URL例: `f?p=141:4:SESSION_ID::NO::P4_QATR_ID:123`

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | 項目ID | タイプ | 必須 | 説明 |
|--------|--------|--------|------|------|
| QATR ID | P4_QATR_ID | Hidden | Yes | テスト実行結果のプライマリキー |

## 表示項目

### Invalid Objectsレポート（インタラクティブ・レポート）

| カラム名 | カラム別名 | 表示順序 | 説明 |
|---------|-----------|---------|------|
| Object | QATO_OBJECT_NAME | 10 | 違反オブジェクトの名前 |
| Details | QATO_OBJECT_DETAILS | 20 | オブジェクトの詳細情報（位置、属性など） |

**レポート設定**:
- データソース: QA_TEST_RUN_INVALID_OBJECTSテーブル
- WHERE条件: QATO_QATR_ID = :P4_QATR_ID
- データなしメッセージ: No data found.
- ページネーション: X〜Y行表示（画面下部右寄せ）
- ダウンロード: CSV有効

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション |
|---------|--------|----------|----------|
| Close | CLOSE | CLOSE | ダイアログを閉じる |

## イベント仕様

### 1-Close Dialog

**トリガー**: CLOSEボタンクリック

**処理フロー**:
1. ダイアログを閉じる（NATIVE_DIALOG_CLOSE）

## データベース更新仕様

### 操作別データベース影響一覧

Invalid Objects画面は読み取り専用であり、データベース更新は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_TEST_RUN_INVALID_OBJECTS | SELECT | P4_QATR_IDに基づいて違反オブジェクト一覧を取得 |

### テーブル構造

#### QA_TEST_RUN_INVALID_OBJECTS

| カラム名 | データ型 | 説明 |
|---------|---------|------|
| QATO_ID | NUMBER | プライマリキー |
| QATO_OBJECT_NAME | VARCHAR2 | 違反オブジェクト名 |
| QATO_OBJECT_DETAILS | VARCHAR2 | オブジェクト詳細情報 |
| QATO_QATR_ID | NUMBER | テスト実行結果ID（外部キー） |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | 違反オブジェクトがない場合 | No data found. |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| P4_QATR_IDが無効 | 空のレポートが表示される |
| レコードが見つからない | 「No data found.」メッセージを表示 |

## 備考

- 本画面はモーダルダイアログとして表示され、親画面（Dashboard）の上に重ねて表示される
- インタラクティブ・レポートの検索バーは非表示（p_show_search_bar=>'N'）
- 違反オブジェクト情報はqa_unit_tests_pkg.p_save_scheme_faulty_objectsにより、テスト実行時にQA_TEST_RUN_INVALID_OBJECTSに保存される
- レポートのカラム幅は自動調整
- AutocompleteはセキュリティのためOFFに設定
- ダイアログ幅はデフォルト設定を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | モーダルダイアログとインタラクティブ・レポートの構成 |

**主要処理フロー**:
1. **行14-24**: `wwv_flow_imp_page.create_page`でモーダルダイアログ設定
2. **行25-42**: Invalid Objectsリージョン（インタラクティブ・レポート）の定義
3. **行43-60**: Buttons Containerリージョンの定義
4. **行61-77**: CLOSEボタンの定義
5. **行78-160**: ワークシート・カラム定義（QATO_OBJECT_NAME、QATO_OBJECT_DETAILS）
6. **行161-185**: P4_QATR_ID Hidden項目の定義
7. **行186-210**: Dynamic Action（Close Dialog）の定義

#### Step 2: データ保存ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | p_save_scheme_faulty_objectsの実装 |

**主要処理フロー**:
- **行1062-1070**: `p_save_scheme_faulty_objects`で違反オブジェクトをINSERT
- **行1072-1141**: `p_handle_test_result`から`p_save_scheme_faulty_objects`を呼び出し

### プログラム呼び出し階層図

```
Invalid Objects Page (Page 4)
    |
    +-- [Page Load]
    |       |
    |       +-- Interactive Report Query
    |               |
    |               +-- SELECT FROM QA_TEST_RUN_INVALID_OBJECTS
    |                   WHERE QATO_QATR_ID = :P4_QATR_ID
    |
    +-- [Button: CLOSE]
            |
            +-- Dynamic Action: Close Dialog
                    |
                    +-- NATIVE_DIALOG_CLOSE
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Dashboard画面               Page 4 Load                      Invalid Objects
(P4_QATR_ID)        ───>   Interactive Report        ───>   一覧表示
    |                            |
    v                            v
テスト実行時                QA_TEST_RUN_INVALID_OBJECTS
    |                       WHERE QATO_QATR_ID = :P4_QATR_ID
    v
qa_unit_tests_pkg
.p_save_scheme_faulty_objects
    |
    v
INSERT INTO QA_TEST_RUN_INVALID_OBJECTS
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | ソース | Invalid Objects画面定義 |
| qa_unit_tests_pkg.sql | `src/plsql/pkg/qa_unit_tests_pkg.sql` | ソース | 違反オブジェクト保存処理 |
| page_00001.sql | `src/apex/f141/application/pages/page_00001.sql` | ソース | Dashboard画面（呼び出し元） |
